/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.logic;

import java.util.Iterator;
import java.util.function.Function;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.hooks.IArmorInteractModifier;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.TinkerModifiers;

@Mod.EventBusSubscriber(modid="tconstruct", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class InteractionHandler {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SubscribeEvent
    static void beforeEntityInteract(PlayerInteractEvent.EntityInteract event) {
        ItemStack stack = event.getItemStack();
        Player player = event.getPlayer();
        InteractionHand hand = event.getHand();
        EquipmentSlot slotType = Util.getSlotType(hand);
        if (!stack.m_204117_(TinkerTags.Items.HELD)) {
            if (!stack.m_41619_()) return;
            stack = player.m_6844_(EquipmentSlot.CHEST);
            if (!stack.m_204117_(TinkerTags.Items.CHESTPLATES)) return;
            slotType = EquipmentSlot.CHEST;
        }
        ToolStack tool = ToolStack.from(stack);
        Entity target = event.getTarget();
        for (ModifierEntry entry : tool.getModifierList()) {
            InteractionResult result = entry.getModifier().beforeEntityUse(tool, entry.getLevel(), player, target, hand, slotType);
            if (!result.m_19077_()) continue;
            event.setCanceled(true);
            event.setCancellationResult(result);
            return;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    static void afterEntityInteract(PlayerInteractEvent.EntityInteract event) {
        ItemStack chestplate;
        Player player = event.getPlayer();
        if (event.getItemStack().m_41619_() && !player.m_5833_() && (chestplate = player.m_6844_(EquipmentSlot.CHEST)).m_204117_(TinkerTags.Items.CHESTPLATES)) {
            event.setCanceled(true);
            ToolStack tool = ToolStack.from(chestplate);
            Entity target = event.getTarget();
            InteractionHand hand = event.getHand();
            InteractionResult result = target.m_6096_(player, hand);
            if (result.m_19077_()) {
                event.setCancellationResult(result);
                return;
            }
            if (target instanceof LivingEntity) {
                LivingEntity livingTarget = (LivingEntity)target;
                for (ModifierEntry entry : tool.getModifierList()) {
                    result = entry.getModifier().afterEntityUse(tool, entry.getLevel(), player, livingTarget, hand, EquipmentSlot.CHEST);
                    if (!result.m_19077_()) continue;
                    event.setCanceled(true);
                    event.setCancellationResult(result);
                    return;
                }
            }
            result = InteractionHandler.onChestplateUse(player, chestplate, hand);
            event.setCancellationResult(result);
        }
    }

    private static InteractionResult onBlockUse(UseOnContext context, IToolStackView tool, ItemStack stack, Function<ModifierEntry, InteractionResult> callback) {
        Player player = context.m_43723_();
        Level world = context.m_43725_();
        BlockInWorld info = new BlockInWorld((LevelReader)world, context.m_8083_(), false);
        if (player != null && !player.m_150110_().f_35938_ && !stack.m_204121_((Registry)Registry.f_122824_, info)) {
            return InteractionResult.PASS;
        }
        for (ModifierEntry entry : tool.getModifierList()) {
            InteractionResult result = callback.apply(entry);
            if (!result.m_19077_()) continue;
            if (player != null) {
                player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
            }
            return result;
        }
        return InteractionResult.PASS;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    static void chestplateInteractWithBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemStack chestplate;
        Player player = event.getPlayer();
        if (event.getItemStack().m_41619_() && !player.m_5833_() && (chestplate = player.m_6844_(EquipmentSlot.CHEST)).m_204117_(TinkerTags.Items.CHESTPLATES)) {
            InteractionResult result;
            InteractionResult result2;
            InteractionResult result3;
            ToolStack tool = ToolStack.from(chestplate);
            InteractionHand hand = event.getHand();
            BlockHitResult trace = event.getHitVec();
            UseOnContext context = new UseOnContext(player, hand, trace);
            if (event.getUseItem() != Event.Result.DENY && (result3 = InteractionHandler.onBlockUse(context, tool, chestplate, entry -> entry.getModifier().beforeBlockUse(tool, entry.getLevel(), context, EquipmentSlot.CHEST))).m_19077_()) {
                event.setCanceled(true);
                event.setCancellationResult(result3);
                return;
            }
            BlockPos pos = event.getPos();
            Event.Result useBlock = event.getUseBlock();
            if ((useBlock == Event.Result.ALLOW || useBlock != Event.Result.DENY && (!player.m_36341_() || player.m_21120_(Util.getOpposite(hand)).doesSneakBypassUse((LevelReader)player.m_183503_(), pos, player))) && (result2 = player.f_19853_.m_8055_(pos).m_60664_(player.f_19853_, player, hand, trace)).m_19077_()) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.f_10562_.m_45482_(serverPlayer, pos, ItemStack.f_41583_);
                }
                event.setCanceled(true);
                event.setCancellationResult(result2);
                return;
            }
            Event.Result useItem = event.getUseItem();
            event.setCancellationResult(InteractionResult.PASS);
            if (useItem != Event.Result.DENY && (useItem == Event.Result.ALLOW || !player.m_36335_().m_41519_(chestplate.m_41720_())) && (result = InteractionHandler.onBlockUse(context, tool, chestplate, entry -> entry.getModifier().afterBlockUse(tool, entry.getLevel(), context, EquipmentSlot.CHEST))).m_19077_()) {
                event.setCanceled(true);
                event.setCancellationResult(result);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.f_10562_.m_45482_(serverPlayer, pos, ItemStack.f_41583_);
                }
                return;
            }
            result = InteractionHandler.onChestplateUse(player, chestplate, hand);
            event.setCanceled(true);
            event.setCancellationResult(result);
        }
    }

    public static InteractionResult onChestplateUse(Player player, ItemStack chestplate, InteractionHand hand) {
        if (player.m_36335_().m_41519_(chestplate.m_41720_())) {
            return InteractionResult.PASS;
        }
        ToolStack tool = ToolStack.from(chestplate);
        for (ModifierEntry entry : tool.getModifierList()) {
            InteractionResult result = entry.getModifier().onToolUse(tool, entry.getLevel(), player.f_19853_, player, hand, EquipmentSlot.CHEST);
            if (!result.m_19077_()) continue;
            return result;
        }
        return InteractionResult.PASS;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    static void onChestplateAttack(AttackEntityEvent event) {
        ToolStack tool;
        ItemStack chestplate;
        Player attacker = event.getPlayer();
        if (attacker.m_21205_().m_41619_() && (chestplate = attacker.m_6844_(EquipmentSlot.CHEST)).m_204117_(TinkerTags.Items.UNARMED) && !(tool = ToolStack.from(chestplate)).isBroken() && tool.getModifierLevel(TinkerModifiers.unarmed.getId()) > 0) {
            ToolAttackUtil.attackEntity(tool, (LivingEntity)attacker, InteractionHand.MAIN_HAND, event.getTarget(), ToolAttackUtil.getCooldownFunction(attacker, InteractionHand.MAIN_HAND), false, EquipmentSlot.CHEST);
            event.setCanceled(true);
        }
    }

    public static boolean startArmorInteract(Player player, EquipmentSlot slotType) {
        ItemStack helmet;
        if (!player.m_5833_() && (helmet = player.m_6844_(slotType)).m_204117_(TinkerTags.Items.ARMOR)) {
            ModifierEntry entry;
            IArmorInteractModifier helmetInteract;
            ToolStack tool = ToolStack.from(helmet);
            Iterator<ModifierEntry> iterator = tool.getModifierList().iterator();
            while (iterator.hasNext() && ((helmetInteract = (entry = iterator.next()).getModifier().getModule(IArmorInteractModifier.class)) == null || !helmetInteract.startArmorInteract(tool, entry.getLevel(), player, slotType))) {
            }
            return true;
        }
        return false;
    }

    public static boolean stopArmorInteract(Player player, EquipmentSlot slotType) {
        ItemStack helmet;
        if (!player.m_5833_() && (helmet = player.m_6844_(slotType)).m_204117_(TinkerTags.Items.ARMOR)) {
            ToolStack tool = ToolStack.from(helmet);
            for (ModifierEntry entry : tool.getModifierList()) {
                IArmorInteractModifier helmetInteract = entry.getModifier().getModule(IArmorInteractModifier.class);
                if (helmetInteract == null) continue;
                helmetInteract.stopArmorInteract(tool, entry.getLevel(), player, slotType);
            }
            return true;
        }
        return false;
    }
}

